unit uMainControl;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DB;

type
  TMainControl = class(TForm)
    Shape1: TShape;
    Label1: TLabel;
    Timer1: TTimer;
    btnExit: TLabel;
    procedure FormActivate(Sender: TObject);
    function  CheckValid:boolean;
    procedure InitDB;
    procedure btnExitMouseEnter(Sender: TObject);
    procedure btnExitMouseLeave(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CheckExistRelated;
  private
    { Private declarations }
    StepNbr : integer;
  public
    { Public declarations }
  end;

var
  MainControl: TMainControl;

implementation

uses uSetTutorArrange, udm, uSetDetail;

{$R *.dfm}

procedure TMainControl.CheckExistRelated;
var i:integer;
    s:array [1..6] of variant;
    ss:variant;
begin
  dm.tDetail.Filter := 'SchYear = '+IntToStr(vSchYear);
  dm.tDetail.Filtered := true;
  dm.tTutorArrange.Filter := 'SchYear = '+IntToStr(vSchYear);
  dm.tTutorArrange.Filtered := true;

  dm.tDetail.First;
  dm.tTutorArrange.First;
  while not dm.tTutorArrange.eof do begin
    for i := 1 to dm.tTutorArrange.FieldByName('Nbr').AsInteger do begin
      s[1] := dm.tTutorArrange.FieldByName('ClassID').AsString;
      s[2] := dm.tTutorArrange.FieldByName('Subj').AsString;
      s[3] := dm.tTutorArrange.FieldByName('TchrID').AsString;
      s[4] := dm.tTutorArrange.FieldByName('RoomID').AsString;
      s[5] := IntToStr(i);
      s[6] := vSchYear;
      ss   := VarArrayOf([S[1], S[2], S[3], S[4], S[5],S[6]]);
      if dm.tDetail.Locate('ClassCode; SubjectCode; TeacherID; RoomCode; Nbr; SchYear', ss, []) then begin { create Record }
        dm.tDetail.edit;
        dm.tDetail.FieldByName('Flag').AsBoolean     := true;
        dm.tDetail.FieldByName('ExLesson').AsInteger := 99;
        dm.tDetail.Post;
      end
      else begin
        dm.tDetail.Insert;
        dm.tDetail.FieldByName('ClassCode').AsString   := dm.tTutorArrange.FieldByName('ClassID').AsString;
        dm.tDetail.FieldByName('SubjectCode').AsString := dm.tTutorArrange.FieldByName('Subj').AsString;
        if dm.qSubject.locate('Code', dm.tTutorArrange.FieldByName('Subj').AsString, []) then
          dm.tDetail.FieldByName('SubjectID').AsInteger := dm.qSubject.FieldByName('id').AsInteger;
        dm.tDetail.FieldByName('TeacherCode').AsString := dm.tTutorArrange.FieldByName('TchrCode').AsString;
        if dm.tTeacher.locate('Code', dm.tTutorArrange.FieldByName('TchrCode').AsString, []) then
          dm.tDetail.FieldByName('TeacherID').AsInteger := dm.tTeacher.FieldByName('id').AsInteger;
        dm.tDetail.FieldByName('RoomCode').AsString    := dm.tTutorArrange.FieldByName('RoomID').AsString;
        dm.tDetail.FieldByName('Flag').AsBoolean       := true;
        dm.tDetail.FieldByName('Nbr').AsString         := IntToStr(i);
        dm.tDetail.FieldByName('ExLesson').AsInteger := 99;
        dm.tDetail.Post;
      end;
    end; { end for loop }
    dm.tTutorArrange.Next;
  end; { end while loop }
end;

procedure TMainControl.FormActivate(Sender: TObject);
begin
  WindowState := wsMaximized;
  while StepNbr = 0 do begin
    repeat
      SetTutorArrange.ShowModal;
    until CheckValid = true;
    InitDB;
    btnExit.Visible := true;
    StepNbr := 1;
    SetDetail.ShowModal;
  end;
end;

function TMainControl.CheckValid:boolean;
var Okay: boolean;
    S:string;
begin
  Okay := true;
  S    := '';
  dm.tClass.first;
  while not dm.tClass.Eof do begin
    if length(dm.tClass.FieldByName('ID').AsString) = 2 then begin
      if dm.tClass.FieldByName('Nbr').AsInteger < dm.tClass.FieldByName('MaxNbr').AsInteger then begin
        if S = ''
        then S := dm.tClass.FieldByName('ID').AsString
        else S := S + ', '+dm.tClass.FieldByName('ID').AsString;
        Okay := false;
      end;
    end;
    dm.tClass.Next;
  end;
  if not Okay then begin
    if MessageDlg(S + 'UZƿJAФp߯dNC', mtConfirmation,
                  [mbYes, mbNo], 0) = mrYes
    then begin
      Okay := true;
//      Application.Terminate;
    end
    else dm.tClass.first;
  end
  else begin
    dm.tDetail.Open;
    dm.tDetail.First;
    while not dm.tDetail.Eof do begin
      if dm.tTeacher.Locate('Code', dm.tDetail.FieldByName('TeacherCode').AsString, [])
      or (dm.tTeacher.FieldByName('ID').AsString <> dm.tDetail.FieldByName('TeacherID').AsString) then begin
        dm.tDetail.Edit;
        dm.tDetail.FieldByName('TeacherID').AsString := dm.tTeacher.FieldByName('ID').AsString;
      end;
      if dm.qSubject.Locate('Code', dm.tDetail.FieldByName('SubjectCode').AsString, [])
      or (dm.qSubject.FieldByName('ID').AsString <> dm.tDetail.FieldByName('SubjectID').AsString) then begin
        dm.tDetail.Edit;
        dm.tDetail.FieldByName('SubjectID').AsString := dm.qSubject.FieldByName('ID').AsString;
      end;
      if dm.tDetail.state in [dsEdit, dsInsert] then dm.tDetail.post;
      dm.tDetail.Next;
    end;
    dm.tDetail.Close;
  end;
  Result := Okay;
end;

procedure TMainControl.InitDB;
var i:integer;
    s:array [1..6] of variant;
    ss:variant;
    tCode:string;
begin
  dm.tTutorArrange.Filtered := false;
  dm.tDetail.Filter := 'SchYear = '+IntToStr(vSchYear);
  dm.tDetail.Filtered := true;
  dm.tDetail.Open;
  dm.tDetail.Last;
  dm.tTeacher.Filter := 'LastYear >= '+IntToStr(vSchYear);
  dm.tTeacher.Filtered := true;
  dm.tTeacher.Open;
  dm.tTutorArrange.Filter := 'SchYear = '+IntToStr(vSchYear);
  dm.tTutorArrange.Filtered := true;
  dm.tTutorArrange.Open;

{  while not dm.tDetail.Bof do begin
    if dm.tTeacher.Locate('Code', dm.tDetail.FieldByName('TeacherCode').AsString, [])
    then tCode := dm.tTeacher.FieldByName('id').AsString
    else begin
      tCode := '';
      ShowMessage('No this teacher');
    end;
    if dm.tTutorArrange.Locate('ClassID;SubjID;TchrID',
       VarArrayOf([dm.tDetail.FieldByName('ClassCode').AsString,
                   dm.tDetail.FieldByName('SubjectID').AsString,
                   tCode]),[])
    then begin
      if dm.tTutorArrange.FieldByName('Nbr').AsInteger >= dm.tDetail.FieldByName('Nbr').AsInteger
      then begin
        if dm.tTutorArrange.FieldByName('RoomID').AsString >= dm.tDetail.FieldByName('RoomCode').AsString
        then
        // go up one record
        dm.tDetail.Prior
        else
        dm.tDetail.delete;
      end;Report valid
      else begin
        dm.tDetail.Delete;
      end;
    end
    else begin
      dm.tDetail.Delete;
    end
  end;     }


  dm.tDetail.Close;
  dm.tTutorArrange.Close;
  dm.tTutorArrange.Open;
  dm.tTutorArrange.first;
  dm.tDetail.Open;
  dm.tDetail.First;
  while not dm.tDetail.eof do begin
    dm.tDetail.edit;
    dm.tDetail.FieldByName('Flag').AsBoolean := false;
    dm.tDetail.Post;
    dm.tDetail.next;
  end;
  while not dm.tTutorArrange.Eof do begin
    for i := 1 to dm.tTutorArrange.FieldByName('Nbr').AsInteger do begin
      s[1] := dm.tTutorArrange.FieldByName('ClassID').AsString;
      s[2] := dm.tTutorArrange.FieldByName('Subj').AsString;
      s[3] := dm.tTutorArrange.FieldByName('TchrID').AsString;
      s[4] := dm.tTutorArrange.FieldByName('RoomID').AsString;
      s[5] := IntToStr(i);
      s[6] := vSchYear;
      ss   := VarArrayOf([S[1], S[2], S[3], S[4], S[5], S[6]]);
      if dm.tDetail.Locate('ClassCode; SubjectCode; TeacherID; RoomCode; Nbr; SchYear', ss, []) then begin { create Record }
        dm.tDetail.edit;
        dm.tDetail.FieldByName('Flag').AsBoolean := true;
        dm.tDetail.FieldByName('ExLesson').AsInteger   := 99;
        dm.tDetail.Post;
      end
      else begin
        dm.tDetail.Insert;
        dm.tDetail.FieldByName('ClassCode').AsString   := dm.tTutorArrange.FieldByName('ClassID').AsString;
        dm.tDetail.FieldByName('SubjectCode').AsString := dm.tTutorArrange.FieldByName('Subj').AsString;
        if dm.qSubject.locate('Code', dm.tTutorArrange.FieldByName('Subj').AsString, []) then
          dm.tDetail.FieldByName('SubjectID').AsInteger := dm.qSubject.FieldByName('id').AsInteger;
        dm.tDetail.FieldByName('TeacherCode').AsString := dm.tTutorArrange.FieldByName('TchrCode').AsString;
        if dm.tTeacher.locate('Code', dm.tTutorArrange.FieldByName('TchrCode').AsString, []) then
          dm.tDetail.FieldByName('TeacherID').AsInteger := dm.tTeacher.FieldByName('id').AsInteger;
        dm.tDetail.FieldByName('RoomCode').AsString    := dm.tTutorArrange.FieldByName('RoomID').AsString;
        dm.tDetail.FieldByName('Flag').AsBoolean       := true;
        dm.tDetail.FieldByName('Nbr').AsString         := IntToStr(i);
        dm.tDetail.FieldByName('ExLesson').AsInteger   := 99;
        dm.tDetail.FieldByName('SchYear').AsInteger    := vSchYear;
        dm.tDetail.Post;
      end;
    end; { end for loop }
    dm.tTutorArrange.Next;
  end; { end while loop }
  dm.tDetail.Filter   := 'Flag = false';
  dm.tDetail.Filtered := true;
  dm.tDetail.first;
  while not dm.tDetail.IsEmpty do dm.tDetail.delete;
  dm.tDetail.Filtered := false;
end;

procedure TMainControl.btnExitMouseEnter(Sender: TObject);
begin
  TLabel(Sender).Color      := clYellow;
  TLabel(Sender).Font.Color := clNavy;
end;

procedure TMainControl.btnExitMouseLeave(Sender: TObject);
begin
  TLabel(Sender).Color      := clCream;
  TLabel(Sender).Font.Color := clTeal;
end;

procedure TMainControl.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMainControl.FormCreate(Sender: TObject);
begin
  StepNbr := 0;
end;

end.
